clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"	
	
*** Program to estimate revenue table

	import delimited "iri_wm_panel_count.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator

	gen week_end = qtrid*13 if qtrid<24
	gen week_begin = 1+week_end-13 if qtrid<24
	replace week_end = 313 if qtrid==24
	replace week_begin = 300 if qtrid==24
	replace week_end = qtrid*13+1 if qtrid>24
	replace week_begin = 1+week_end-13+1 if qtrid>24

	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (week_end >= week`i')
		capture gen enter`i' = (week_begin <= week`i' & week_end > week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	
	encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores qtrid

	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
		
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Create variables		
		
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		egen `var'_count = rowtotal(`var'_*)
		}
	egen food_count=rowtotal(*_count)
	
	compress
	
	egen count_1 = rowtotal(*_count_1)
	egen count_4 = rowtotal(*_count_4)
	tabstat food_count count_1 count_4 carbbev_count-yogurt_count, stat(N mean sd p10 p25 median p75 p90) c(s)		

keep stores wm wm_* mkt chain* enter firmtype treat_nwm qtr* week* *count* first last
	
** Stack datasets		
		
	preserve
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		keep stores qtrid wm wm_* mkt chain* enter firmtype `var'_* food_count treat_nwm week* first last
		gen category = "`var'"
		rename `var'_count* count*
		save `var'.dta, replace
		restore, preserve
		}
	restore, not

	clear
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		append using `var'.dta
		erase `var'.dta
		}

	encode category, gen(cat)
	egen storecat = group(stores cat)
	xtset storecat qtrid
	
	gen logcount = log(count)
	gen logfood_count = log(food_count)
	gen share_1 = count_1/count
	gen share_4 = count_4/count
	
	gen wm_lt7 = wm_1+wm_3+wm_5+wm_7
	gen wm_lt5 = wm_1+wm_3+wm_5	
	
** Regressions		
	cd "\Results"		
		
	foreach var of varlist logcount {
		reghdfe `var' enter wm_1-wm_11 first last, a(qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel replace
		reghdfe `var' enter wm_1-wm_11 first last i.chain i.mkt, a(qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel
		reghdfe `var' enter wm_1-wm_11 first last, a(stores qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel		
		reghdfe `var' enter wm_1-wm_11 first last i.mkt#c.qtrid i.mkt#c.qtrid#c.qtrid, a(stores qtrid) cluster(stores) keepsing	 
			outreg2 using final_count, excel		
		reghdfe `var' enter wm_1-wm_11 first last i.mkt#c.qtrid i.mkt#c.qtrid#c.qtrid i.treat_nwm#c.qtrid i.treat_nwm#c.qtrid#c.qtrid, a(stores qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel
		reghdfe `var' enter wm_lt5 first last i.mkt#c.qtrid i.mkt#c.qtrid#c.qtrid i.treat_nwm#c.qtrid i.treat_nwm#c.qtrid#c.qtrid, a(stores qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel				
		}
		
	foreach var of varlist share_* {
		reghdfe `var' enter wm_1-wm_11 first last i.cat#c.qtrid i.cat#c.qtrid#c.qtrid i.mkt#c.qtrid i.mkt#c.qtrid#c.qtrid i.treat_nwm#c.qtrid i.treat_nwm#c.qtrid#c.qtrid, a(storecat qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel
		reghdfe `var' enter wm_lt5 first last i.cat#c.qtrid i.cat#c.qtrid#c.qtrid i.mkt#c.qtrid i.mkt#c.qtrid#c.qtrid i.treat_nwm#c.qtrid i.treat_nwm#c.qtrid#c.qtrid, a(storecat qtrid) cluster(stores) keepsing	
			outreg2 using final_count, excel				
		}		
		
		
		
		
		
		
		
	